/*******************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1994  by Altera Corp. All Rights Reserved.       *
*******************************************************************/
/*
TRUTHTABLE     : 
          ----------------
           ena	d   |   q
          ---------------- 
           H   	L	|   L
           H   	H	|   H
           L   	X	|   q
          ---------------- 
*/
`celldefine

`timescale  1ns /  100ps
module latch (q, ena, d);
	parameter size =1;
	input
		ena,
		d;
	output
		q;

  reg r_q;
  buf #1 (q,  r_q);

  always @(d or ena)
        if (ena == 1)
            r_q = d;

specify
     specparam area = 1;
     specparam capacitance$d = 1;
     specparam capacitance$ena = 1;

    // Timing Checks
    $hold(posedge ena,d,1.0);
    $setup(d,posedge ena,1.0);

    // Path Delays
    (d => q) = (1.0,1.0);
    (ena => q) = (1.0,1.0);
endspecify

endmodule
`endcelldefine
